
///////////////////////////////////////////////////////////////////////////////
//
//   ROCKWELL SEMICONDUCTOR SYSTEMS - COMMERCIAL GPS BUSINESS
//
///////////////////////////////////////////////////////////////////////////////
//
//
//   BLDZMSG.C - Build Zodiac Message
// 
//
//   DESCRIPTION
//
//   Function to dispatch Zodiac message builds to the appropriate build
//   routine.
//
//
//   REVISION HISTORY
//
//   $Log:   V:\Projects\Labmon\Source\Archives\BLDZMSG.C_v  $
//   
//      Rev 1.17   15 Dec 1999 14:18:48   phungh
//   Take out msg1392, add msg1292 to 
//   accommodate the message ID change
//   in zodiac software 2.57
//   
//      Rev 1.16   08 Dec 1999 15:56:34   phungh
//   Add build for message 1306, 1334, 1337,
//   1390, 1392
//   
//      Rev 1.15   09 Nov 1998 16:58:10   phungh
//   Lbmon511: Add cF7 key combination to
//   the menu to allow choosing antenna type
//   ( passive/active ).  Msg1218 module was
//   added.
//   
//      Rev 1.8   Jul 06 1998 09:06:48   BANHND
//   added more DR features
//   
//      Rev 1.5   Jul 09 1997 09:43:30   COLEJ
//   Multiple Changes...
//   
//      Rev 1.4   Feb 25 1997 14:22:58   COLEJ
//   Added 1208 and 1317 message 
//   
//      Rev 1.3   Feb 12 1997 16:04:56   COLEJ
//    
//   
//      Rev 1.2   Nov 14 1996 11:25:04   COLEJ
//    
//   
//      Rev 1.1   Aug 13 1996 13:05:34   COLEJ
//    
//   
//      Rev 1.0   13 May 1996 14:52:24   GPSADMIN
//   Initial release to version control.
//
//
////////////////////////////////////////////////////////////////////////////////

#include <stdio.h>

#include "gentypes.h"
#include "gencons.h"
#include "display.h"
#include "ztypes.h"
#include "util.h"   

// Build a Zodiac Message in the buffer
tBOOL BldZMsg(tMSGBUF *ZMsgBuf, tZMSG ZMsg, tUSHORT MsgNum)                
{ 
   char buff[80] = "";
   

   switch(MsgNum){

      // NE output messages
      case 1000: 
         Bld1000(ZMsgBuf, &ZMsg.Msg1000);
         break;    
      case 1001: 
         Bld1001(ZMsgBuf, &ZMsg.Msg1001); 
         break;              
      case 1002: 
         Bld1002(ZMsgBuf, &ZMsg.Msg1002); 
         break;
      case 1003: 
         Bld1003(ZMsgBuf, &ZMsg.Msg1003); 
         break;
      case 1005: 
         Bld1005(ZMsgBuf, &ZMsg.Msg1005); 
         break;           
      case 1009: 
         Bld1009(ZMsgBuf, &ZMsg.Msg1009); 
         break;              

      // ME output messages
      case 1100: 
         Bld1100(ZMsgBuf, &ZMsg.Msg1100); 
         break;
      case 1130: 
         Bld1130(ZMsgBuf, &ZMsg.Msg1130); 
         break;        
      case 1135: 
         Bld1135(ZMsgBuf, &ZMsg.Msg1135); 
         break;        
      case 1136: 
         Bld1136(ZMsgBuf, &ZMsg.Msg1136); 
         break;
      case 1160: 
         Bld1160(ZMsgBuf, &ZMsg.Msg1160); 
         break;        
      case 1180: 
         Bld1180(ZMsgBuf, &ZMsg.Msg1180); 
         break;        
      case 1190: 
         Bld1190(ZMsgBuf, &ZMsg.Msg1190); 
         break;        
               
      // NE input messages                                                  
      case 1200: 
         Bld1200(ZMsgBuf, &ZMsg.Msg1200); 
         break;
      case 1208: 
         Bld1208(ZMsgBuf, &ZMsg.Msg1208); 
         break;
      case 1210: 
         Bld1210(ZMsgBuf, &ZMsg.Msg1210); 
         break;   
      case 1211:
         Bld1211(ZMsgBuf, &ZMsg.Msg1211); 
         break;      
      case 1212: 
         Bld1212(ZMsgBuf, &ZMsg.Msg1212); 
         break; 
      case 1213: 
         Bld1213(ZMsgBuf, &ZMsg.Msg1213); 
         break;   
      case 1214: 
         Bld1214(ZMsgBuf, &ZMsg.Msg1214); 
         break;
      case 1216: 
         Bld1216(ZMsgBuf, &ZMsg.Msg1216); 
         break;   
      case 1217: 
         Bld1217(ZMsgBuf, &ZMsg.Msg1217); 
         break;   
      case 1218: 
         Bld1218(ZMsgBuf, &ZMsg.Msg1218); 
         break;   
      case 1219: 
         Bld1219(ZMsgBuf, &ZMsg.Msg1219); 
         break;   
      case 1220: 
         Bld1220(ZMsgBuf, &ZMsg.Msg1220); 
         break;   
      case 1221: 
         Bld1221(ZMsgBuf, &ZMsg.Msg1221); 
         break;
      case 1240: 
         Bld1240(ZMsgBuf, &ZMsg.Msg1240); 
         break;
      case 1241: 
         Bld1241(ZMsgBuf, &ZMsg.Msg1241); 
         break;
      case 1242: 
         Bld1242(ZMsgBuf, &ZMsg.Msg1242); 
         break;
      case 1270: 
         Bld1270(ZMsgBuf, &ZMsg.Msg1270); 
         break;
      case 1292: 
         Bld1292(ZMsgBuf, &ZMsg.Msg1292); 
         break;
        
      // ME input messages
      case 1300: 
         Bld1300(ZMsgBuf, &ZMsg.Msg1300); 
         break;
      case 1303: 
         Bld1303(ZMsgBuf, &ZMsg.Msg1303); 
         break;   
      case 1304: 
         Bld1304(ZMsgBuf, &ZMsg.Msg1304); 
         break;   
      case 1305: 
         Bld1305(ZMsgBuf, &ZMsg.Msg1305); 
         break;   
      case 1306: 
         Bld1306(ZMsgBuf, &ZMsg.Msg1306); 
         break;   
      case 1310: 
         Bld1310(ZMsgBuf, &ZMsg.Msg1310); 
         break;
      case 1317: 
         Bld1317(ZMsgBuf, &ZMsg.Msg1317); 
         break;
      case 1330: 
         Bld1330(ZMsgBuf, &ZMsg.Msg1330); 
         break;   
      case 1331: 
         Bld1331(ZMsgBuf, &ZMsg.Msg1331); 
         break;
      case 1334: 
         Bld1334(ZMsgBuf, &ZMsg.Msg1334); 
         break;
      case 1337: 
         Bld1337(ZMsgBuf, &ZMsg.Msg1337); 
         break;
      case 1360: 
         Bld1360(ZMsgBuf, &ZMsg.Msg1360); 
         break;
      case 1380: 
         Bld1380(ZMsgBuf, &ZMsg.Msg1380); 
         break;
      case 1390: 
         Bld1390(ZMsgBuf, &ZMsg.Msg1390); 
         break;
//take out because of msgID changed 1392->1292      case 1392: 
//         Bld1392(ZMsgBuf, &ZMsg.Msg1392); 
//         break;
       
      // message type not supported 
      default: 
         sprintf(buff, " UNSUPPORTED BINARY MESSAGE %04d", MsgNum);
         ShowText(buff, CMDR, CMDC);
         return FALSE; 
   }
   return TRUE;
}
